/* MIDLETThreadTest and ThreadTest were written to demonstrate how to get info from the Internet from a phone.
 * It points out that the HTTP request has to be made in a separate thread to work.
 */
package edu.uci.ics.luci.projects.nomatic.test.dd;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MIDLETThreadTest extends MIDlet implements CommandListener,
		Runnable, ItemCommandListener {

	private Display display;

	private Form mainForm;

	private Thread time;
	
	public synchronized void mainFormAppend(String s){
		mainForm.append(s);
	}

	public void tick() {
		mainFormAppend("1\n");
	}

	/**
	 * Our main loop, called at a fixed rate by our game Thread
	 */
	public void run() {

		while (true) {
			// set wanted loop delay in milliseconds
			int loopDelay = 15000;
			// get the time at the start of the loop
			long loopStartTime = System.currentTimeMillis();
			// call our tick() function which will be our apps heartbeat
			tick();
			// get time at end of loop
			long loopEndTime = System.currentTimeMillis();
			// caluclate the difference in time from start til end of loop
			int loopTime = (int) (loopEndTime - loopStartTime);
			// if the difference is less than what we want
			if (loopTime < loopDelay) {
				try {
					// then sleep for the time needed to fullfill our wanted
					// rate
					Thread.sleep(loopDelay - loopTime);
				} catch (Exception e) {
				}
			}
		}
	}

	/*
	 * destroyApp() is called by the AMS when the MIDlet is to be destroyed
	 */
	protected void destroyApp(boolean unconditional) {

	}

	/*
	 * pauseApp() is called by the AMS when the MIDlet should enter a paused
	 * state. This is an environment pause. The most common example is an
	 * incoming phone call on the device, which will cause the pauseApp() method
	 * to be called. This allows us to perform the needed actions within our
	 * MIDlet
	 */
	protected void pauseApp() {
	}

	/*
	 * Command listener for each picture
	 */
	public void commandAction(Command c, Item item) {

	}

	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {

		if (mainForm == null) {
			mainForm = new Form("Thread Test");
		}
		if (time == null) {
			time = new Thread(this);
		}
		if (display == null) {
			display = Display.getDisplay(this);
		}
		display.setCurrent(mainForm);

		new ThreadTest(this);

		time.start();
	}

	public void commandAction(Command arg0, Displayable arg1) {
		// TODO Auto-generated method stub

	}
}
