/* This Test looks for GPS data on the Internet and if found reports the text that
 it sees in  a nicely formatted way*/
package edu.uci.ics.luci.projects.nomatic.test.bb;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import edu.uci.ics.luci.projects.nomatic.GPS.GPSComponent;
import edu.uci.ics.luci.projects.nomatic.GPS.NMEASentence;

public class NetFormatGPSTest extends MIDlet implements CommandListener,
		Runnable, ItemCommandListener {

	private Display display;

	private Form mainForm;

	private Command exitCommand = new Command("Exit", Command.EXIT, 99);

	private Thread time;

	GPSComponent gPS;

	private synchronized Form getMainForm() {
		return mainForm;
	}

	private synchronized void mainFormAppend(String x) {
		mainForm.append(x);
	}

	private synchronized void setMainForm(Form mainForm) {
		this.mainForm = mainForm;
	}

	private synchronized Display getDisplay() {
		return display;
	}

	private synchronized void setDisplay(Display display) {
		this.display = display;
	}

	private synchronized GPSComponent getGPS() {
		return gPS;
	}

	private synchronized void setGPS(GPSComponent gps) {
		gPS = gps;
	}

	private synchronized Thread getTime() {
		return time;
	}

	private synchronized void setTime(Thread time) {
		this.time = time;
	}

	public void tick() {
		if (getGPS().getBlueTooth() != null) {
			mainFormAppend("Bluetooth log messages:\n\n");
			mainFormAppend(getGPS().getBlueTooth().getLogMessage());
			if (getGPS().isGPSComponentSetupDone()) {
				if (getGPS().getInputStream() != null) {
					mainFormAppend("\n");
					getGPS().fillGPSBuffer();
					if (getGPS().checkGPSBufferForNMEASentence("$GPRMC")) {
						String x;
						getMainForm().deleteAll();
						getMainForm().append("GPS Data Found\n");
						NMEASentence n = gPS.getGPSBuffer("$GPRMC", true);
						if (n.safeNMEAFieldsGet(NMEASentence.STATUS).compareTo(
								"A") == 0) {
							getMainForm().append("Data Is Valid\n");
						} else {
							getMainForm().append("Data Is Invalid\n");
						}

						getMainForm().append("Latitude: ");
						x = n.safeNMEAFieldsGet(NMEASentence.LATITUDE);
						getMainForm().append(x.substring(0, 2) + " "
								+ x.substring(2) + " ");
						getMainForm()
								.append(n
										.safeNMEAFieldsGet(NMEASentence.LATITUDEHEMISPHERE));
						getMainForm().append("\n");
						getMainForm().append("Longitude: ");
						x = n.safeNMEAFieldsGet(NMEASentence.LONGITUDE);
						getMainForm().append(x.substring(0, 3) + " "
								+ x.substring(3) + " ");
						getMainForm().append(" ");
						getMainForm()
								.append(n
										.safeNMEAFieldsGet(NMEASentence.LONGITUDEHEMISPHERE));
						getMainForm().append("\n");

						getMainForm().append("Heading: ");
						getMainForm().append(n
										.safeNMEAFieldsGet(NMEASentence.COURSEOVERGROUND));
						getMainForm().append("\n");

						getMainForm().append("Speed: ");
						getMainForm()
								.append(n
										.safeNMEAFieldsGet(NMEASentence.SPEEDOVERGROUND));
						getMainForm().append("\n");
						// for (Iterator i = n.NMEAFields.keySet().iterator();
						// i.hasNext();) {
						// String key = (String) i.next();
						// mainForm.append(key + ":" +
						// n.safeNMEAFieldsGet(key)+"\n");
						// }
					} else {
						mainFormAppend("GPS Data Not Found\n");
					}
				} else {
					mainFormAppend("Input Stream not ready:\n");
					mainFormAppend(getGPS().getLogMessage(true));
				}
			} else {
				mainFormAppend("GPS Component set up is not complete\n");
			}
		} else {
			mainFormAppend("Bluetooth not initialized\n");
		}
	}

	/**
	 * Our main loop, called at a fixed rate by our game Thread
	 */
	public void run() {

		while (true) {
			// set wanted loop delay in milliseconds
			int loopDelay = 10000;
			// get the time at the start of the loop
			long loopStartTime = System.currentTimeMillis();
			// call our tick() function which will be our apps heartbeat
			tick();
			// get time at end of loop
			long loopEndTime = System.currentTimeMillis();
			// caluclate the difference in time from start til end of loop
			int loopTime = (int) (loopEndTime - loopStartTime);
			// if the difference is less than what we want
			if (loopTime < loopDelay) {
				try {
					// then sleep for the time needed to fullfill our wanted
					// rate
					Thread.sleep(loopDelay - loopTime);
				} catch (Exception e) {
				}
			}
		}
	}

	/*
	 * destroyApp() is called by the AMS when the MIDlet is to be destroyed
	 */
	protected void destroyApp(boolean unconditional) {

	}

	/*
	 * pauseApp() is called by the AMS when the MIDlet should enter a paused
	 * state. This is an environment pause. The most common example is an
	 * incoming phone call on the device, which will cause the pauseApp() method
	 * to be called. This allows us to perform the needed actions within our
	 * MIDlet
	 */
	protected void pauseApp() {
	}

	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {

		if (getMainForm() == null) {
			Form f = new Form("Net Format GPS Test");
			setMainForm(f);
			getMainForm().addCommand(exitCommand);
			getMainForm().setCommandListener(this);
		}
		if (getTime() == null) {
			setTime(new Thread(this));
		}

		if (getDisplay() == null) {
			setDisplay(Display.getDisplay(this));
		}
		getDisplay().setCurrent(getMainForm());

		if (getGPS() == null) {
			mainFormAppend("Constructing GPSComponent\n");
			setGPS(new GPSComponent(
					GPSComponent.CONFIG_USE_NETWORK_GPS_PROXY,
					"http://www.ics.uci.edu/~djp3/classes/2007_04_02_INF132/code/GPSDATA01.txt"));
			mainFormAppend("Done Constructing GPSComponent");
		}

		getTime().start();
	}

	public void commandAction(Command c, Item arg1) {

	}

	public void commandAction(Command c, Displayable arg1) {

		if (c == exitCommand) {
			destroyApp(true);
			notifyDestroyed();
		}
	}

}
