/* This Test scans the Bluetooth devices in the area, looks for a GPS device and if found and streams the text that
 it is sees coming form the GPS*/
package edu.uci.ics.luci.projects.nomatic.test.bb;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import edu.uci.ics.luci.projects.nomatic.GPS.GPSComponent;

public class BlueDumpGPSTest extends MIDlet implements CommandListener,
		Runnable, ItemCommandListener {

	private Display display;

	private Form mainForm;

	private Command exitCommand = new Command("Exit", Command.EXIT, 99);

	private Thread time;

	GPSComponent gPS;

	private synchronized Form getMainForm() {
		return mainForm;
	}

	private synchronized void mainFormAppend(String x) {
		mainForm.append(x);
	}

	private synchronized void setMainForm(Form mainForm) {
		this.mainForm = mainForm;
	}

	private synchronized Display getDisplay() {
		return display;
	}

	private synchronized void setDisplay(Display display) {
		this.display = display;
	}

	private synchronized GPSComponent getGPS() {
		return gPS;
	}

	private synchronized void setGPS(GPSComponent gps) {
		gPS = gps;
	}

	private synchronized Thread getTime() {
		return time;
	}

	private synchronized void setTime(Thread time) {
		this.time = time;
	}

	public void tick() {
		if (getGPS().getBlueTooth() != null) {
			mainFormAppend("Bluetooth log messages:\n\n");
			mainFormAppend(getGPS().getBlueTooth().getLogMessage());
			if (getGPS().isGPSComponentSetupDone()) {
				if (getGPS().getInputStream() != null) {
					mainFormAppend("\n");
					getGPS().fillGPSBuffer();
					if (getGPS().checkGPSBufferForNMEASentence("GP")) {
						mainFormAppend(getGPS().getGPSBuffer("$GP",true,GPSComponent.USE_FIRST));
					} else {
						mainFormAppend("GPS Data Not Found\n");
					}
				} else {
					mainFormAppend("Input Stream not ready:\n");
					mainFormAppend(getGPS().getLogMessage(true));
				}
			} else {
				mainFormAppend("GPS Component set up is not complete\n");
			}
		} else {
			mainFormAppend("Bluetooth not initialized\n");
		}
	}

	/**
	 * Our main loop, called at a fixed rate by our game Thread
	 */
	public void run() {

		while (true) {
			// set wanted loop delay in milliseconds
			int loopDelay = 10000;
			// get the time at the start of the loop
			long loopStartTime = System.currentTimeMillis();
			// call our tick() function which will be our apps heartbeat
			tick();
			// get time at end of loop
			long loopEndTime = System.currentTimeMillis();
			// caluclate the difference in time from start til end of loop
			int loopTime = (int) (loopEndTime - loopStartTime);
			// if the difference is less than what we want
			if (loopTime < loopDelay) {
				try {
					// then sleep for the time needed to fullfill our wanted
					// rate
					Thread.sleep(loopDelay - loopTime);
				} catch (Exception e) {
				}
			}
		}
	}

	/*
	 * destroyApp() is called by the AMS when the MIDlet is to be destroyed
	 */
	protected void destroyApp(boolean unconditional) {

	}

	/*
	 * pauseApp() is called by the AMS when the MIDlet should enter a paused
	 * state. This is an environment pause. The most common example is an
	 * incoming phone call on the device, which will cause the pauseApp() method
	 * to be called. This allows us to perform the needed actions within our
	 * MIDlet
	 */
	protected void pauseApp() {
	}

	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {

		if (getMainForm() == null) {
			Form f = new Form("Blue Dump GPS Test");
			setMainForm(f);
			getMainForm().addCommand(exitCommand);
			getMainForm().setCommandListener(this);
		}
		if (getTime() == null) {
			setTime(new Thread(this));
		}

		if (getDisplay() == null) {
			setDisplay(Display.getDisplay(this));
		}
		getDisplay().setCurrent(getMainForm());

		if (getGPS() == null) {
			mainFormAppend("Constructing GPSComponent\n");
			setGPS(new GPSComponent(GPSComponent.CONFIG_USE_BLUETOOTH_GPS));
			mainFormAppend("Done Constructing GPSComponent");
		}

		getTime().start();
	}

	public void commandAction(Command c, Item arg1) {

	}

	public void commandAction(Command c, Displayable arg1) {

		if (c == exitCommand) {
			destroyApp(true);
			notifyDestroyed();
		}
	}

}
