/**
 * This Test scans the Bluetooth devices in the area and for the last one found, scans the services that it provides
 */
package edu.uci.ics.luci.projects.nomatic.test.aa;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import edu.uci.ics.luci.projects.nomatic.Bluetooth.Bluetooth;

public class BluetoothTest extends MIDlet implements CommandListener, Runnable,
		ItemCommandListener {


	private Display display;

	private Form mainForm;

	private Thread time;

	private Bluetooth blueTooth;


	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {
		if (mainForm ==null){
			mainForm = new Form("Bluetooth Test");
		}
		if (time ==null){
			time = new Thread(this);
		}
		if(display ==null){
			display = Display.getDisplay(this);
		}

		display.setCurrent(mainForm);
		mainForm.append("BluetoothTest Application\n");

		mainForm.append("Constructing test Bluetooth instance\n");
		try {
			blueTooth = new Bluetooth(Bluetooth.MATCH_EVERYTHING, null);

		} catch (Exception e) {
			mainForm.append("Exception: " + e.toString());
		}
		mainForm.append("Done Constructing test Bluetooth instance\n");

		time.start();
	}

	public void tick() {
		mainForm.append(blueTooth.getLogMessage());
	}

	/**
	 * Our main loop, called at a fixed rate by our game Thread
	 */
	public void run() {
	
		while (true) {
			// set wanted loop delay in milliseconds
			int loopDelay = 15000;
			// get the time at the start of the loop
			long loopStartTime = System.currentTimeMillis();
			// call our tick() function which will be our apps heartbeat
			tick();
			// get time at end of loop
			long loopEndTime = System.currentTimeMillis();
			// caluclate the difference in time from start til end of loop
			int loopTime = (int) (loopEndTime - loopStartTime);
			// if the difference is less than what we want
			if (loopTime < loopDelay) {
				try {
					// then sleep for the time needed to fullfill our wanted
					// rate
					Thread.sleep(loopDelay - loopTime);
				} catch (Exception e) {
				}
			}
		}
	}

	protected void pauseApp() {
		
	}

	protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
		
	}

	public void commandAction(Command arg0, Displayable arg1) {
		
	}

	public void commandAction(Command arg0, Item arg1) {
		
	}
}
