package edu.uci.ics.luci.projects.nomatic.Network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Form;

public class HTTPPostData implements Runnable {
	private String URL;

	private String data;

	private Thread thread;

	private Form main;

	private synchronized Form getMain() {
		return main;
	}

	private synchronized void setMain(Form main) {
		this.main = main;
	}

	private synchronized String getData() {
		return data;
	}

	private synchronized void setData(String data) {
		this.data = data;
	}

	private synchronized String getURL() {
		return URL;
	}

	private synchronized void setURL(String url) {
		URL = url;
	}

	private synchronized Thread getThread() {
		return thread;
	}

	private synchronized void setThread(Thread thread) {
		this.thread = thread;
	}

	public HTTPPostData(String data, Form f) {
		this("http://luci.ics.uci.edu/eraseme/samplePOST/cgiPost.php", data, f);
	}

	public HTTPPostData(String URL, String data, Form f) {
		/* Initialize general fields */
		setURL(URL);
		setData(data);
		setMain(f);
		setThread(new Thread(this));
		getThread().start();
	}

	public void run() {
		HttpConnection hc = null;
		DataOutputStream dos = null;
		DataInputStream dis = null;
		byte[] request_body;
		StringBuffer messageBuffer = new StringBuffer();

		try {
			hc = (HttpConnection) Connector
					.open(getURL(), Connector.READ_WRITE);
			hc.setRequestMethod(HttpConnection.POST);
			hc.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
			hc.setRequestProperty("Content-Language", "en-US");
			hc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			dos = hc.openDataOutputStream();
			request_body = getData().getBytes();
			for (int i = 0; i < request_body.length; i++) {
				dos.writeByte(request_body[i]);
			}
			dos.flush();
			dos.close();

			dis = new DataInputStream(hc.openInputStream());
			int ch;
			// Check the Content-Length first
			long len = hc.getLength();
			if (len != -1) {
				for (int i = 0; i < len; i++) {
					if ((ch = dis.read()) != -1) {
						messageBuffer.append((char) ch);
					} else {
						// if the content-length is not available
						while ((ch = dis.read()) != -1) {
							messageBuffer.append((char) ch);
						}
					}
				}
			}
			dis.close();
		} catch (IOException ioe) {
			messageBuffer = new StringBuffer("ERROR!");
		} finally {
			// Free up i/o streams and http connection
			try {
				if (hc != null)
					hc.close();
			} catch (IOException ignored) {
			}
			try {
				if (dis != null)
					dis.close();
			} catch (IOException ignored) {
			}
			try {
				if (dos != null)
					dos.close();
			} catch (IOException ignored) {
			}
		}
		getMain().append(messageBuffer.toString());

	}

}
