package edu.uci.ics.luci.projects.nomatic.GPS;


import edu.uci.ics.luci.projects.nomatic.collections.HashMap;

public class NMEASentence {

	public static final String ANTENNAHEIGHT = "AntennaHeight";

	public static final String COURSEOVERGROUND = "Course";

	public static final String DATEOFFIX = "DateStamp";

	public static final String DIFFERENTIALGPSDATAAGE = "DifferentialGPSdataage";

	public static final String DIFFERENTIALREFERENCESTATIONID = "DifferentialReferenceStationID";

	public static final String GEOIDALHEIGHT = "GeoidalHeight";

	public static final String GPSQUALITY = "Quality";

	public static final String HORIZONTALDILUTIONOFPRECISION = "HorizontalDilutionOfPrecision";

	public static final String LATITUDE = "Latitude";

	public static final String LATITUDEHEMISPHERE = "LatitudeHemisphere";

	public static final String LONGITUDE = "Longitude";

	public static final String LONGITUDEHEMISPHERE = "LongitudeHemisphere";

	public static final String MAGNETICVARIATION = "Variation";

	public static final String MAGNETICVARIATIONDIRECTION = "VariationDirection";

	public static final String MODE = "ModeIndicator";

	public static final String NUMOFSATELLITES = "NumberOfSatellites";

	public static final String SPEEDOVERGROUND = "Speed(knots)";

	public static final String STATUS = "ValidStatus";

	public static final String TIME_OF_FIX = "Timeoffix";

	public static final String CALCULATEDCHECKSUM = "CalculatedCHECKSUM";
	public static final String OBSERVEDCHECKSUM = "ObservedChecksum";
	
	public HashMap NMEAFields;
	
	/*Parameters for constructor*/
	public static final int USE_FIRST=0;
	public static final int USE_LAST=1;

	/**
	 * Get the last valid NMEA Sentence from a String of text
	 * 
	 * @param line
	 */
	public NMEASentence(String line,int FIRST_OR_LAST) {
		NMEAFields = new HashMap();
		String canonical_line = line.toUpperCase();

		int start, end;
		while ((start = canonical_line.indexOf("$GPRMC")) != -1) {

			/* Find the start of the checksum */
			end = canonical_line.indexOf("*", start);
			/* If we found a checksum marker and there is a checksum */
			if ((end != -1) && (canonical_line.substring(end).length() >= 3)) {
				NMEAFields.clear();
				loadRMCSentence(canonical_line.substring(start, end + 3));
				/* If we want to use the first one, then grab it and quit*/
				if(FIRST_OR_LAST == USE_FIRST){
					canonical_line=new String("");
				}
				/*Otherwise roll through the string to the end */
				else{
					canonical_line = canonical_line.substring(end + 3);
				}
			} else {
				/* we have a partial GPRMC string */
				canonical_line = "";
			}
		}

	}

	/**
	 * Remove the leading characters of line if they match sub.
	 * 
	 * @param sub
	 *            Characters to remove
	 * @param line
	 *            String from which the leading characters are removed if they
	 *            match sub
	 * @return "line" with "sub removed. null if sub is not the first substring
	 *         of line. null if sub is null.
	 */
	public static String NMEAConsume(String sub, String line) {
		if (line == null) {
			return (null);
		}
		if (sub == null) {
			return (line);
		}
		int idx = 0;
		if ((idx = line.indexOf(sub)) == -1) {
			return null;
		} else if (idx != 0) {
			return null;
		} else {
			return line.substring(idx + sub.length());
		}
	}

	/**
	 * Grab all the text up to the string split and return it. If split or line
	 * is null the return value is null.If the split string is not in the line
	 * then all of line is returned
	 * 
	 * @param split
	 *            The token that separates line into fields
	 * @param line
	 * @return
	 */

	public static String NMEAGrab(String split, String line) {
		if (split == null) {
			return null;
		}
		if (line == null) {
			return null;
		}
		int idx = 0;
		if ((idx = line.indexOf(split)) == -1) {
			return line;
		} else {
			return line.substring(0, idx);
		}
	}

	public void loadRMCSentence(String line) {
		String x;

		int check = NMEAChecksum("GPRMC,", 0);

		if ((line = NMEAConsume("$GPRMC,", line)) == null) {
			return;
		}
		;
		NMEAFields.put(NMEASentence.TIME_OF_FIX, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.STATUS, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.LATITUDE, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields
				.put(NMEASentence.LATITUDEHEMISPHERE, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.LONGITUDE, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.LONGITUDEHEMISPHERE,
				x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.SPEEDOVERGROUND, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.COURSEOVERGROUND, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.DATEOFFIX, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.MAGNETICVARIATION, x = NMEAGrab(",", line));
		x = x + ",";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;
		check = NMEAChecksum(x, check);

		NMEAFields.put(NMEASentence.MAGNETICVARIATIONDIRECTION, x = NMEAGrab(
				"*", line));
		check = NMEAChecksum(x, check);
		x = x + "*";
		if ((line = NMEAConsume(x, line)) == null) {
			return;
		}
		;

		NMEAFields.put(NMEASentence.CALCULATEDCHECKSUM, Integer.toHexString(check).toUpperCase());
		NMEAFields.put(NMEASentence.OBSERVEDCHECKSUM,line);
		
		/* If the checksum doesn't match set the info to be invalid */
		if (Integer.toHexString(check).toUpperCase().compareTo(line) != 0) {
			NMEAFields.put(NMEASentence.STATUS, "V");
		}

	}

	/**
	 * This function updates a NMEA checksum with new characters.
	 * 
	 * @param string
	 *            The characters to add to the checksum
	 * @param i
	 *            the current checksum
	 * @return the updated checksum
	 */
	public static int NMEAChecksum(String string, int i) {
		char[] c = new char[string.length()];

		string.getChars(0, string.length(), c, 0);

		for (int j = 0; j < c.length; j++) {
			i = i ^ c[j];
		}
		return (i);
	}

	public String safeNMEAFieldsGet(String y) {
		String x = (String)NMEAFields.get(y);
		if(x == null){
			return("(null)");
		}
		else{
			return(x);
		}
	}
}
