package edu.uci.ics.luci.projects.nomatic.Camera;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DisplayCanvas extends Canvas implements CommandListener {
	private final CameraComponentInterface midlet;

	private Image image = null;

	public DisplayCanvas(CameraComponentInterface midlet) {
		this.midlet = midlet;
		addCommand(new Command("Back", Command.BACK, 1));
		setCommandListener(this);
	}

	public void paint(Graphics g) {
		g.setColor(0x0000FFFF); // cyan
		g.fillRect(0, 0, getWidth(), getHeight());
		if (image != null) {
			g.drawImage(image, getWidth() / 2, getHeight() / 2,
					Graphics.VCENTER | Graphics.HCENTER);
		}
	}

	public void setImage(byte[] pngImage) {
		image = Image.createImage(pngImage, 0, pngImage.length);
	}

	public void commandAction(Command c, Displayable d) {
		midlet.displayCanvasBack();
	}

}
