package edu.uci.ics.luci.projects.nomatic.Camera;

import java.io.IOException;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class CameraCanvas extends Canvas implements CommandListener {
	private final CameraComponentInterface midlet;

	private Command doneCommand = null;

	private Command captureCommand = null;

	private Player player = null;

	private VideoControl videoControl = null;

	private boolean active = false;

	// Two strings for displaying error messages
	private String message1 = null;

	private String message2 = null;

	public CameraCanvas(CameraComponentInterface midlet) {
		this.midlet = midlet;
		doneCommand = new Command("Done", Command.SCREEN, 2);
		addCommand(doneCommand);
		setCommandListener(this);
		try {
			player = Manager.createPlayer("capture://video");
			player.realize();
			// Grab the video control and set it to the current display.
			videoControl = (VideoControl) (player.getControl("VideoControl"));
			if (videoControl == null) {
				discardPlayer();
				message1 = "Unsupported:";
				message2 = "Can't get video control";
			} else {
				videoControl.initDisplayMode(VideoControl.USE_DIRECT_VIDEO,
						this);
				// centre video, letting it be clipped if it's too big
				int canvasWidth = getWidth();
				int canvasHeight = getHeight();
				int displayWidth = videoControl.getDisplayWidth();
				int displayHeight = videoControl.getDisplayHeight();
				int x = (canvasWidth - displayWidth) / 2;
				int y = (canvasHeight - displayHeight) / 2;
				videoControl.setDisplayLocation(x, y);
				captureCommand = new Command("Capture", Command.SCREEN, 1);
				addCommand(captureCommand);
			}
		} catch (IOException ioe) {
			discardPlayer();
			message1 = "IOException:";
			message2 = ioe.getMessage();
		} catch (MediaException me) {
			discardPlayer();
			message1 = "MediaException:";
			message2 = me.getMessage();
		} catch (SecurityException se) {
			discardPlayer();
			message1 = "SecurityException";
			message2 = se.getMessage();
		}
	}

	// Called in case of exception to make sure invalid players are closed
	private void discardPlayer() {
		if (player != null) {
			player.close();
			player = null;
		}
		videoControl = null;
	}

	public void paint(Graphics g) {
		g.setColor(0x00FFFF00); // yellow
		g.fillRect(0, 0, getWidth(), getHeight());
		if (message1 != null) {
			g.setColor(0x00000000); // black
			g.drawString(message1, 1, 1, Graphics.TOP | Graphics.LEFT);
			g.drawString(message2, 1, 1 + g.getFont().getHeight(), Graphics.TOP
					| Graphics.LEFT);
		}
	}

	public synchronized void start() {
		if ((player != null) && !active) {
			try {
				player.start();
				videoControl.setVisible(true);
			} catch (MediaException me) {
				message1 = "Media exception:";
				message2 = me.getMessage();
			} catch (SecurityException se) {
				message1 = "SecurityException";
				message2 = se.getMessage();
			}
			active = true;
		}
	}

	public synchronized void stop() {
		if ((player != null) && active) {
			try {
				videoControl.setVisible(false);
				player.stop();
			} catch (MediaException me) {
				message1 = "MediaException:";
				message2 = me.getMessage();
			}
			active = false;
		}
	}

	public void commandAction(Command c, Displayable d) {
		if (c == doneCommand) {
			midlet.cameraCanvasDone();
		} else if (c == captureCommand) {
			takeSnapshot();
		}
	}

	public void keyPressed(int keyCode) {
		if (getGameAction(keyCode) == FIRE) {
			takeSnapshot();
		}
	}

	private void takeSnapshot() {
		if (player != null) {
			try {
				byte[] pngImage = videoControl.getSnapshot(null);
				midlet.cameraCanvasCaptured(pngImage);
			} catch (MediaException me) {
				message1 = "MediaException:";
				message2 = me.getMessage();
			}
		}
	}
}
