package edu.uci.ics.luci.projects.nomatic.Bluetooth;

import java.io.IOException;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

class Listener implements DiscoveryListener {
	/** Magic String for an RFCOMM connection * */
	private final static UUID uuid = new UUID("0003", true);

	/** Pointer to the Bluetooth object that is using us * */
	private Bluetooth bluetoothParent;

	/** the blueooth device signature we are looking for * */
	private String bluetoothSignature;

	private int match;

	private StringBuffer logMessage;

	private RemoteDevice remote;

	private ServiceRecord serviceRecord;

	private StreamConnection streamConnection;

	/**
	 * @param bluetoothParent
	 * @param logMessage
	 */
	public Listener(Bluetooth bluetoothParent, String bluetoothSignature,
			int match) {
		setBluetoothParent(bluetoothParent);
		setBluetoothSignature(bluetoothSignature);
		setLogMessage(new StringBuffer());
		setMatch(match);
	}

	private synchronized Bluetooth getBluetoothParent() {
		return bluetoothParent;
	}

	private synchronized void setBluetoothParent(Bluetooth bluetoothParent) {
		this.bluetoothParent = bluetoothParent;
	}

	private synchronized String getBluetoothSignature() {
		return bluetoothSignature;
	}

	private synchronized void setBluetoothSignature(String bluetoothSignature) {
		this.bluetoothSignature = bluetoothSignature;
	}

	private synchronized StringBuffer getLogMessage() {
		return logMessage;
	}

	private synchronized void setLogMessage(StringBuffer logMessage) {
		this.logMessage = logMessage;
	}
	
	private synchronized void logMessageClear() {
		logMessage.delete(0, logMessage.length());
	}

	private synchronized void logMessageAppend(String c){
		logMessage.append(c);
	}

	private synchronized int getMatch() {
		return match;
	}

	private synchronized void setMatch(int match) {
		this.match = match;
	}

	private synchronized RemoteDevice getRemote() {
		return remote;
	}

	private synchronized void setRemote(RemoteDevice remote) {
		this.remote = remote;
	}

	private synchronized ServiceRecord getServiceRecord() {
		return serviceRecord;
	}

	private synchronized void setServiceRecord(ServiceRecord serviceRecord) {
		this.serviceRecord = serviceRecord;
	}

	private synchronized StreamConnection getStreamConnection() {
		return streamConnection;
	}

	private synchronized void setStreamConnection(StreamConnection streamConnection) {
		this.streamConnection = streamConnection;
	}

	private void addBluetoothLogMessage(String m) {
		logMessageAppend(m);
		if (getBluetoothParent() != null) {
			getBluetoothParent().logMessageAppend(getLogMessage().toString());
			logMessageClear();
		}
	}

	public synchronized void deviceDiscovered(RemoteDevice remoteDevice,
			DeviceClass deviceClass) {
		addBluetoothLogMessage("in deviceDiscovered\n");
		try {
			if (remoteDevice != null) {
				String deviceName = remoteDevice.getFriendlyName(false);
				if ((getMatch() != Bluetooth.NEVER_GET_TO_MATCHING)
						&& (getMatch() != Bluetooth.MATCH_NOTHING)) {
					if (deviceName.equals(getBluetoothSignature())
							|| (getMatch() == Bluetooth.MATCH_EVERYTHING)) {
						setRemote(remoteDevice);
						addBluetoothLogMessage("Found a device: ");
						addBluetoothLogMessage(deviceName);
						addBluetoothLogMessage("\n");
						addBluetoothLogMessage("Device address: ");
						addBluetoothLogMessage(getRemote().getBluetoothAddress());
						addBluetoothLogMessage("\n");
					}
				}
			}
		} catch (IOException ex) {
			// screwed right here
		}
		addBluetoothLogMessage("out of deviceDiscovered\n");

	}

	/**
	 * device discovery completed.
	 * 
	 * @param transId
	 */
	public synchronized void inquiryCompleted(int transId) {
		addBluetoothLogMessage("In inquiryCompleted\n");
		/* We found the device, now find the services offered */
		new DoServiceDiscovery();
		addBluetoothLogMessage("Out of inquiryCompleted\n");
	}

	public synchronized void servicesDiscovered(int transId,
			ServiceRecord[] svcRec) {
		addBluetoothLogMessage("In servicesDiscovered:" + transId + ","
				+ svcRec.length + "\n");
		try {

			for (int i = 0; i < svcRec.length; i++) {
				// Util.printServiceRecord( svcRec[i] );

				addBluetoothLogMessage("Service discovered: ");
				addBluetoothLogMessage(svcRec[i].toString());
				// EndPoint endpt = findEndPointByTransId( transId );
				addBluetoothLogMessage("\n");

				setServiceRecord(svcRec[i]);

			}

		} catch (Exception e) {
			addBluetoothLogMessage("Exception" + e.toString());

		}
		addBluetoothLogMessage("Out of inquiryCompleted\n");
	}

	/**
	 * service discovery is completed.
	 * 
	 * @param int0
	 * @param int1
	 */
	public synchronized void serviceSearchCompleted(int transID, int respCode) {
		addBluetoothLogMessage("in services completed\n");

		//		

		if (respCode == SERVICE_SEARCH_COMPLETED)
			addBluetoothLogMessage("SS_COMP\n");
		else if (respCode == SERVICE_SEARCH_TERMINATED)
			addBluetoothLogMessage("SS_TERMIN\n");
		else if (respCode == SERVICE_SEARCH_ERROR)
			addBluetoothLogMessage("SS_ERROR\n");
		else if (respCode == SERVICE_SEARCH_NO_RECORDS)
			addBluetoothLogMessage("SS_NO_RECORDS\n");
		else if (respCode == SERVICE_SEARCH_DEVICE_NOT_REACHABLE)
			addBluetoothLogMessage("SS_DEV_NOT_REACH\n");
		else
			addBluetoothLogMessage("UNKOWN\n");
		try {
			String url = getServiceRecord().getConnectionURL(
					ServiceRecord.NOAUTHENTICATE_NOENCRYPT, false);
			addBluetoothLogMessage(url);
			addBluetoothLogMessage("after connectionURL\n");

			setStreamConnection(( StreamConnection) Connector.open(url));

			addBluetoothLogMessage("after Connector.open\n");

			getBluetoothParent().setInputStream(getStreamConnection().openInputStream());
			getBluetoothParent().setBluetoothSetupDone(true);
		} catch (Exception e) {
			addBluetoothLogMessage("Exception line=254\r ");
		}
		addBluetoothLogMessage("Out of services completed\n");

	}

	class DoServiceDiscovery // extends TimerTask
	{
		public DoServiceDiscovery() {
			run();
		}

		public synchronized void run() {

			try {
				addBluetoothLogMessage("In DoServiceDiscovery Class\n");

				// uuid = new UUID(address, false);

				if (getBluetoothParent() != null) {
					if (getBluetoothParent().getAgent() != null) {
						if (getRemote() != null) {

							getBluetoothParent().getAgent().searchServices(
									null // null to
									// indicate
									// retrieve
									// default
									// attributes
									,
									new UUID[] { uuid } // Blue service UUID
									// SerialPort
									,
									getRemote(),
									new Listener(getBluetoothParent(),
											getBluetoothSignature(), getMatch()));
						}
					}
				}

				//
			} catch (BluetoothStateException e) {
				addBluetoothLogMessage("Exception Line=294");

			}
			addBluetoothLogMessage("out of DoServiceDiscovery Class\n");

		}
	}
}
