package edu.uci.ics.luci.projects.nomatic.Bluetooth;

import java.io.InputStream;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;

public class Bluetooth {

	private DiscoveryAgent agent;

	private LocalDevice localDevice;

	// Bluetooth State
	/**
	 * This is true if this instantiation is just for testing. It is false if it
	 * is actually connecting to someting *
	 */
	private int match;
	public static int NEVER_GET_TO_MATCHING = -1;

	public static int MATCH_NOTHING = 0;

	public static int MATCH_SIGNATURE = 1;

	public static int MATCH_EVERYTHING = 2;

	private boolean bluetoothSetupDone;

	/** This is the name of the device that we are looking for * */
	private String bluetoothSignature;

	/** This is the raw data coming from the device after we have connected to it**/
	private InputStream inputStream;

	/** This is where the error Messages are stored* */
	private StringBuffer logMessage;

	public final static int SIGNAL_MESSAGE = 1;

	public final static int SIGNAL_TERMINATE = 3;

	public final static int SIGNAL_HANDSHAKE_ACK = 4;

	public final static int SIGNAL_TERMINATE_ACK = 5;

	public synchronized boolean isBluetoothSetupDone() {
		return bluetoothSetupDone;
	}

	public synchronized void setBluetoothSetupDone(boolean bluetoothSetupDone) {
		this.bluetoothSetupDone = bluetoothSetupDone;
	}

	private synchronized LocalDevice getLocalDevice() {
		return localDevice;
	}

	private synchronized void setLocalDevice(LocalDevice localDevice) {
		this.localDevice = localDevice;
	}

	/**
	 * returns the input stream associated with the opened device. Returns null
	 * if the stream isn't initialized*
	 */
	public synchronized InputStream getInputStream() {
		return inputStream;
	}

	public synchronized void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	private synchronized String getBluetoothSignature() {
		return bluetoothSignature;
	}

	private synchronized void setBluetoothSignature(String bluetoothSignature) {
		this.bluetoothSignature = bluetoothSignature;
	}

	private synchronized int getMatch() {
		return match;
	}

	private synchronized void setMatch(int match) {
		this.match = match;
	}

	public synchronized DiscoveryAgent getAgent() {
		return agent;
	}
	
	
	private synchronized void setAgent(DiscoveryAgent agent) {
		this.agent = agent;
	}

	public synchronized String getLogMessage() {
		String local = new String("");
		try {
			local = logMessage.toString();
			logMessageClear();
	
		} catch (Exception e) {
			logMessageAppend("\rin getMessages exception: "
					+ e.toString() + "\r");
		}
		return (local);
	}

	private synchronized void setLogMessage(StringBuffer logMessage) {
		this.logMessage = logMessage;
	}

	private synchronized void logMessageClear() {
		logMessage.delete(0, logMessage.length());
	}

	public synchronized void logMessageAppend(String s) {
		logMessage.append(s);
	}

	private void addDevices() {
		logMessageAppend("in addDevices\n");
		try {
			if (getAgent() != null) {
				getAgent().startInquiry(DiscoveryAgent.GIAC, new Listener(this,
						getBluetoothSignature(), getMatch()));
			}

		} catch (BluetoothStateException e) {
			logMessageAppend("exception in addDevices" + e.toString()
					+ "\n");
		}
		logMessageAppend("out of addDevices\n");

	}

	/***************************************************************************
	 * Constructor for testing
	 * 
	 * @param testing
	 *            true if this is an instance of the Bluetooth object that is
	 *            going to be used for testing
	 * @param _bluetoothSignature
	 */
	public Bluetooth(int match, String _bluetoothSignature) {
		setBluetoothSetupDone(false);
		setMatch(match);
		setInputStream(null);
		setLogMessage(new StringBuffer());
		logMessageClear();

		if (_bluetoothSignature == null) {
			setBluetoothSignature("BTGPS 2285B9");
		} else {
			setBluetoothSignature(_bluetoothSignature);
		}

		try {
			if (getMatch() != NEVER_GET_TO_MATCHING) {
				/* Begin the device discovery process */
				setLocalDevice(LocalDevice.getLocalDevice());
				// this.localDevice.setDiscoverable(DiscoveryAgent.GIAC); // set
				// Discover mode to GIAC
				if (getLocalDevice() != null) {
					setAgent(getLocalDevice().getDiscoveryAgent());
					addDevices();
				}
			} else {
				setBluetoothSetupDone(true);
			}

		} catch (Exception e) {
			logMessageAppend("Exception while performing bluetooth device discovery\n "
					+ e.toString());
		}
	}
}
